


<?php $__env->startSection('title', '| Users'); ?>

<?php $__env->startSection('content'); ?>

<div class="container col-lg-8 col-lg-offset-1">
    <h1><i class="fa fa-users"></i> User Administration</h1>
    <hr>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">

            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Address</th>
                    <th>Registered On</th>
                    <th>Email Verif.</th>
                    <th>User Role</th>
                    <th>Operations</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td><?php echo e($user->name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->phone_no); ?></td>
                    <td> 
                        <?php echo e(\Illuminate\Support\Str::limit($user->address, 8, '..')); ?>

                    </td>
                    <td><?php echo e($user->created_at->format('F d, Y h:ia')); ?></td>
                    <td>
                        <?php if($user->email_verified_at): ?>         
                            <i class="fa fa-check" style="color: #44bd32" aria-hidden="true"></i>        
                        <?php else: ?>
                            <i class="fa fa-times" style="color: #c23616" aria-hidden="true"></i>          
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($user->roles()->pluck('name')->implode(' ')); ?></td>
                    <td>
                    <div style="display: flex">
                        <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-info pull-left mr-2" style="margin-right: 3px;">Edit</a>

                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['users.destroy', $user->id] ]); ?>

                        <?php echo Form::submit('Delete', ['class' => 'btn btn-danger']); ?>

                        <?php echo Form::close(); ?>

                    </div>



                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>
    </div>

    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-success">Add User</a>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/c/Users/User/Documents/Code Projects/Laravel Project/Tap/resources/views/users/index.blade.php ENDPATH**/ ?>