


<?php $__env->startSection('title', '| Users'); ?>

<?php $__env->startSection('content'); ?>

<div class="container col-lg-6 col-lg-offset-1">
    <h1><i class="fa fa-users"></i> User Administration</h1>
    <hr>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">

            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Registered On</th>
                    <th>User Role</th>
                    <th>Operations</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td><?php echo e($user->name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->created_at->format('F d, Y h:ia')); ?></td>
                    <td><?php echo e($user->roles()->pluck('name')->implode(' ')); ?></td>
                    <td>
                    <div style="display: flex">
                        <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-info pull-left mr-2" style="margin-right: 3px;">Edit</a>

                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['users.destroy', $user->id] ]); ?>

                        <?php echo Form::submit('Delete', ['class' => 'btn btn-danger']); ?>

                        <?php echo Form::close(); ?>

                    </div>



                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>
    </div>

    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-success">Add User</a>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\User\Documents\Code Projects\Laravel Project\Tap\resources\views/users/index.blade.php ENDPATH**/ ?>