<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'SMS App')); ?></title>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/dataTables.bootstrap4.min.js')); ?>" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/dataTables.bootstrap4.min.css">
</head>
<body>
    <div id="app">

        <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container-fluid">
                <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                    
                    SMS App
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav mr-auto">

                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        <?php if(auth()->guard()->guest()): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                            </li>
                            <?php if(Route::has('register')): ?>
                                 <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                                </li> 
                            <?php endif; ?>
                        <?php else: ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('single-sms')); ?>">Single SMS</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('bulk-sms')); ?>">Bulk SMS</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('groups')); ?>">Groups</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('deliver-sms')); ?>">Delivered SMS</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('pending-sms')); ?>">Pending SMS</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('recieve-sms')); ?>">Recieved SMS</a>
                            </li>

                            <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('buy')); ?>">Buy Balance</a>
                                </li>
                            <?php endif; ?>

                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <?php echo e(Auth::user()->name); ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                    <?php if(auth()->check() && auth()->user()->hasRole('admin')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('twilio-number')); ?>">
                                            Twilio Numbers
                                        </a>
                                   
                                        <a class="dropdown-item" href="<?php echo e(URL::to('users')); ?>">
                                            User Management
                                        </a>
                                    <?php endif; ?>

                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>

                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>

        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
</body>
</html>
<?php /**PATH /mnt/c/Users/User/Documents/Code Projects/Laravel Project/Tap/resources/views/layouts/app.blade.php ENDPATH**/ ?>